jQuery(document).ready(function ($) {
    // Quantity plus
    $(document).on('click', '.qty-plus', function () {
        let count = $(this).siblings('.qty-count');
        let qty = parseInt(count.text()) || 1;
        qty++;
        count.text(qty);
    });

    // AJAX Add to Cart (no alert, no redirect)
    $(document).on('click', '.add-cart-btn', function () {
        const box = $(this).closest('.chaldal-cart-box');
        const product_id = box.data('product_id');
        const quantity = parseInt(box.find('.qty-count').text()) || 1;

        $.ajax({
            url: chaldal_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'chaldal_add_to_cart',
                nonce: chaldal_ajax.nonce,
                product_id,
                quantity
            },
            success: function (res) {
                // Optional: update cart count via fragment
                if (typeof wc_cart_fragments_params !== 'undefined') {
                    $(document.body).trigger('wc_fragment_refresh');
                }
            },
            error: function () {
                // Optional: show console log or visual feedback
                console.log('Cart add failed.');
            }
        });
    });
	
	// ✅ AJAX: Buy Now button (old)
    $(document).on('click', '.buy-now-btn', function () {
        const product_id = $(this).data('product_id');
        $.ajax({
            url: chaldal_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'chaldal_add_to_cart',
                product_id: product_id,
                quantity: 1,
                nonce: chaldal_ajax.nonce
            },
            success: function () {
                window.location.href = '/checkout/';
            }
        });
    });
});
