<?php
/*
Plugin Name: Chaldal
Description: Adds a global plus add to cart button with AJAX quantity increment for WooCommerce products.
Version: 1.0
Author: Your Name
*/

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
// Disable widget and block editors
add_filter('use_widgets_block_editor', '__return_false');
add_filter('gutenberg_use_widgets_block_editor', '__return_false', 100);
add_filter('use_block_editor_for_post', '__return_false');

//cal
// Assets load
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_script('chaldal-js', plugin_dir_url(__FILE__) . 'js/chaldal.js', ['jquery'], null, true);
    wp_localize_script('chaldal-js', 'chaldal_ajax', [
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('chaldal_nonce')
    ]);

    wp_enqueue_style('chaldal-style', plugin_dir_url(__FILE__) . 'css/chaldal.css');
});

// ✅ [wpaddtocard] শর্টকোড
add_shortcode('wpaddtocard', function () {
    global $product;
    if (!$product || !is_a($product, 'WC_Product')) return '';

    $product_id = $product->get_id();

    ob_start(); ?>
    <div class="chaldal-cart-box" data-product_id="<?= esc_attr($product_id) ?>">
        <button class="qty-plus">+</button>
        <span class="qty-count">1</span>
        <button class="add-cart-btn">Cart</button>
    </div>
    <?php
    return ob_get_clean();
});

// ✅ AJAX হ্যান্ডলার
add_action('wp_ajax_chaldal_add_to_cart', 'chaldal_add_to_cart_callback');
add_action('wp_ajax_nopriv_chaldal_add_to_cart', 'chaldal_add_to_cart_callback');

function chaldal_add_to_cart_callback()
{
    check_ajax_referer('chaldal_nonce', 'nonce');

    $product_id = intval($_POST['product_id']);
    $quantity = intval($_POST['quantity']);

    if ($product_id && $quantity > 0) {
        WC()->cart->add_to_cart($product_id, $quantity);
        wp_send_json_success(['msg' => 'Product added to cart!']);
    } else {
        wp_send_json_error(['msg' => 'Invalid data']);
    }
}

// [wpbuynow] shortcode
add_shortcode('wpbuynow', function () {
    global $product;
    if (!$product) return '';

    ob_start();
    ?>
    <button class="buy-now-btn" data-product_id="<?= esc_attr($product->get_id()) ?>">
	 <!-- বাই নাও এর আগের  চিন্হু	<svg style="fill:#fff;" width="22px" height="25px" version="1.1" x="0px" y="0px" viewBox="0 -5 5.153 40.012" data-reactid=".29hj496epw0.f.2.0.0.0.0.2.6.1.0:$19987_Grocery.0.4.0.0"><path d="M38.487 11.472H31.78l6.12-9.643h-8.457L21.9 16.906h5.723l-6.289 14.935z" transform="translate(-21.334 -1.829)" data-reactid=".29hj496epw0.f.2.0.0.0.0.2.6.1.0:$19987_Grocery.0.4.0.0.0"></path></svg> -->
		<span class="wp-3">Buy Now</span>
	</button>
    <?php
    return ob_get_clean();
});
//end cal
//kg
// 1. Add custom field to product edit page
add_action('woocommerce_product_options_general_product_data', function () {
    woocommerce_wp_text_input([
        'id' => '_product_kg',
        'label' => __('Product KG', 'woocommerce'),
        'desc_tip' => true,
        'description' => __('Enter the product weight in KG', 'woocommerce'),
        'type' => 'text',
    ]);
});

// 2. Save custom field value
add_action('woocommerce_process_product_meta', function ($post_id) {
    if (isset($_POST['_product_kg'])) {
        update_post_meta($post_id, '_product_kg', sanitize_text_field($_POST['_product_kg']));
    }
});

// 3. Shortcode to display product KG
add_shortcode('product_kg', function () {
    if (!is_product()) return '';
    global $product;
    if (!$product) return '';
    $product_kg = get_post_meta($product->get_id(), '_product_kg', true);
    return esc_html($product_kg);
});
//kg end
// [WPaccount] Shortcode
function wpaccount_shortcode() {
    // Get the My Account page URL dynamically
    $account_url = function_exists('wc_get_page_permalink') ? wc_get_page_permalink('myaccount') : site_url('/my-account/');

    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();
        $user_avatar_url = get_avatar_url( $user_id );
        $default_avatar_url = get_avatar_url( 0 ); // Default avatar URL without user

        // Check if user's avatar is default
        if ( $user_avatar_url === $default_avatar_url ) {
            // No custom avatar, show icon
            $avatar_html = '<i class="fa fa-user-circle-o" aria-hidden="true"></i>';
        } else {
            // Custom avatar exists
            $avatar_html = '<img src="' . esc_url( $user_avatar_url ) . '" alt="User Avatar" class="user-avatar" style="width:25px;height:25px;border-radius:50%;">';
        }

        return '
        <a href="' . esc_url( $account_url ) . '" class="wp-my-me">
            ' . $avatar_html . '
            <span class="wp-me">Me</span>
        </a>
        ';
    } else {
        return '
        <a href="' . esc_url( $account_url ) . '" class="wp-my-me">
            <span class="fahad">LogIn/SignUp</span>
			<span class="fahadmob">LogIn</span>
        </a>
        ';
    }
}
add_shortcode( 'WPaccount', 'wpaccount_shortcode' );

//end
//// woocommerce_checkout_fields off
add_filter('woocommerce_checkout_fields', 'custom_remove_checkout_fields');

function custom_remove_checkout_fields($fields) {
    // Remove Last Name
    unset($fields['billing']['billing_last_name']);

    // Remove Country / Region
    unset($fields['billing']['billing_country']);

    // Remove Street Address
    unset($fields['billing']['billing_company']);
    unset($fields['billing']['billing_address_2']);

    // Remove Town / City
    unset($fields['billing']['billing_city']);

    // Remove State
    unset($fields['billing']['billing_state']);

    // Remove ZIP Code
    unset($fields['billing']['billing_postcode']);

    // Remove Additional Information (Order Notes)
    unset($fields['order']['order_comments']);

    return $fields;
}
add_action('wp_head', function () {
    ?>
    <style>
        .woocommerce-shipping-fields,
        .woocommerce-additional-fields {
            display: none !important;
        }
		.woocommerce .form-row-first {
			width: 100% !important;
		}
    </style>
    <?php
});

// Remove Additional Information section (Order Notes)
add_filter('woocommerce_enable_order_notes_field', '__return_false');

// Remove Shipping Fields (if not needed)
add_filter('woocommerce_checkout_fields', function ($fields) {
    unset($fields['shipping']);
    return $fields;
});
//end
// Menu shortcode [WproductsMenu]
add_shortcode('WproductsMenu', function () {
    if (!function_exists('wc_get_product_category_list')) return '';

    ob_start();

    $current_cat_id = is_product_category() ? get_queried_object_id() : 0;

    $args = array(
        'taxonomy'   => 'product_cat',
        'parent'     => 0,
        'hide_empty' => false,
    );

    $product_cats = get_terms($args);

    // ক্যাটাগরি দুটি গ্রুপে ভাগ করা
    $cats_with_position = [];
    $cats_without_position = [];

    foreach ($product_cats as $cat) {
        $position = get_term_meta($cat->term_id, 'cat_position', true);
        if ($position) {
            $cats_with_position[] = $cat;
        } else {
            $cats_without_position[] = $cat;
        }
    }

    // Position থাকা ক্যাটাগরি আগে দেখানো
    usort($cats_with_position, function($a, $b) {
        $pos_a = intval(get_term_meta($a->term_id, 'cat_position', true));
        $pos_b = intval(get_term_meta($b->term_id, 'cat_position', true));
        return $pos_a - $pos_b;
    });

    echo '<div class="wproducts-menu">';

    // Position সহ ক্যাটাগরি প্রথমে
    foreach ($cats_with_position as $cat) {
        render_category_menu_item_with_image($cat, $current_cat_id);
    }

    // Position ছাড়া ক্যাটাগরি পরের দিকে
    foreach ($cats_without_position as $cat) {
        render_category_menu_item_with_image($cat, $current_cat_id);
    }

    echo '</div>';

    return ob_get_clean();
});

function render_category_menu_item_with_image($term, $current_cat_id, $level = 0) {
    $child_terms = get_terms(array(
        'taxonomy'   => 'product_cat',
        'parent'     => $term->term_id,
        'hide_empty' => false,
    ));

    // Sort child terms by position
    usort($child_terms, function($a, $b) {
        $pos_a = intval(get_term_meta($a->term_id, 'cat_position', true));
        $pos_b = intval(get_term_meta($b->term_id, 'cat_position', true));
        return $pos_a - $pos_b;
    });

    $is_active = is_category_active($term->term_id, $current_cat_id);
    $style = $is_active ? 'color:#d39b11;' : '';
    $image_id = get_term_meta($term->term_id, 'thumbnail_id', true);
    $image_url = $image_id ? wp_get_attachment_url($image_id) : wc_placeholder_img_src();

    echo '<div style="padding-left:' . ($level * 10) . 'px;">';
    echo '<a href="' . esc_url(get_term_link($term)) . '" class="cat-1 v2">';
    echo '<div class="cat-1">';
    echo '<img src="' . esc_url($image_url) . '" width="20" height="20"> ';
    echo '<span style="' . $style . '">' . esc_html($term->name) . '</span>';
    echo '</div>';
    // শুধুমাত্র প্রথম লেভেলে এবং যদি সাবক্যাটাগরি থাকে, তবেই আইকন দেখাবে
    if ($level === 0 && !empty($child_terms)) {
        echo ' <i class="fa fa-angle-right" aria-hidden="true"></i>';
    }
    echo '</a>';

    if (!empty($child_terms) && $is_active) {
        echo '<div>';
        foreach ($child_terms as $child) {
            render_category_menu_item_with_image($child, $current_cat_id, $level + 1);
        }
        echo '</div>';
    }

    echo '</div>';
}

function is_category_active($term_id, $current_cat_id) {
    if ($term_id == $current_cat_id) return true;
    $ancestors = get_ancestors($current_cat_id, 'product_cat');
    return in_array($term_id, $ancestors);
}

//menu end